# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2001 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CU_cli_rc;
#"@(#)60   1.3   src/rsct/utils/cli/pm/CU_cli_rc.pm.perl, cucli, rsct_rori, roris01a 6/13/00 17:22:25"
######################################################################
#                                                                    #
# Package: CU_cli_rc.pm                                              #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the PERL             #
#   Cluster Utilities CLI commands. Each return code can be          #
#   referenced separately, or as a whole using the 'return_codes'    #
#   EXPORT_TAG.                                                      #
#                                                                    #
# Exit Values (Return Codes descriptions):                           #
#   0  CU_CLI_SUCCESS        Command completed successfully.         #
#   1  CU_CLI_RMC_ERROR      Command terminated due to an underlying #
#                            Cluster Utils error.                    #
#   2  CU_CLI_ERROR          Command terminated due to an underlying #
#                            error in the command script.            #
#   3  CU_CLI_BAD_OPERAND    Command terminated due to user          #
#                            specifying a bad operand.               #
#   4  CU_CLI_BAD_FLAG       Command terminated due to user          # 
#                            specifying an invalid flag.             #
#   5  CU_CLI_USER_ERROR     Command terminated due to a user error. #
#                            For example specifying an undefined     #
#                            Resource name as the Resource operand.  #
#                                                                    #
# Examples:                                                          #
#   use CU_cli_rc qw(CU_CLI_BAD_OPERAND CU_CLI_BAD_FLAG)             #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use CU_cli_rc qw(:return_codes)                                  #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   990408 SAB 48413: Initial design and write.                      #
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    CU_CLI_SUCCESS
                    CU_CLI_UTILS_ERROR
                    CU_CLI_ERROR
                    CU_CLI_BAD_FLAG
                    CU_CLI_BAD_OPERAND
                    CU_CLI_USER_ERROR
);


#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(CU_CLI_SUCCESS
                    CU_CLI_UTILS_ERROR
                    CU_CLI_ERROR
                    CU_CLI_BAD_FLAG
                    CU_CLI_BAD_OPERAND
                    CU_CLI_USER_ERROR
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions (constants)                                #
#--------------------------------------------------------------------#

use constant CU_CLI_SUCCESS         => 0;
use constant CU_CLI_UTILS_ERROR     => 1;
use constant CU_CLI_ERROR           => 2;
use constant CU_CLI_BAD_FLAG        => 3;
use constant CU_CLI_BAD_OPERAND     => 4;
use constant CU_CLI_USER_ERROR      => 5;

